package ru.yandex.calendar.frontend.worker;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.CalendarRequest;
import ru.yandex.calendar.RemoteInfo;
import ru.yandex.calendar.logic.event.ActionSource;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.misc.io.IoFunction0V;
import ru.yandex.misc.support.tl.ThreadLocalHandle;

public class CalendarTaskUtils {

    public static void executeWithCalendarRequest(
            ExecutionContext context,
            ActionSource actionSource,
            IoFunction0V action
    ) throws Exception {
        ThreadLocalHandle request = CalendarRequest.push(
                new RemoteInfo(Option.empty(), Option.empty()),
                actionSource,
                "Executing " + context.getFullJobId().toSerializedString(),
                context.getFullJobId().getTaskId().toString() + "Task"
        );
        try {
            action.applyWithException();
        } finally {
            request.popSafely();
        }
    }
}
