package ru.yandex.calendar.frontend.worker;

import java.util.Map;

import lombok.Value;

import ru.yandex.misc.bender.annotation.BenderBindAllFields;

@BenderBindAllFields
@Value
public class TaskConfiguration {
    TaskTimingConfig defaultConfig;
    Map<String, TaskTimingConfig> configs;

    public TaskConfiguration(TaskTimingConfig defaultConfig, Map<String, TaskTimingConfig> configs) {
        this.defaultConfig = defaultConfig;
        this.configs = configs;
    }

    public TaskConfiguration() {
        defaultConfig = new TaskTimingConfig(5,5);
        configs = Map.of(
                "updateAbsencesFromStaff", new TaskTimingConfig(300, 300),
                "updateResourcesFromCenter", new TaskTimingConfig(10, 10),
                "updateSettingsFromCenter", new TaskTimingConfig(30, 30),
                "staffSynchronizer", new TaskTimingConfig(30, 30)
        );
    }

    public TaskTimingConfig getConfig(String taskName) {
        return configs.getOrDefault(taskName, defaultConfig);
    }
}
