package ru.yandex.calendar.frontend.worker;

import lombok.Value;
import org.joda.time.Duration;

import ru.yandex.commune.bazinga.scheduler.schedule.SchedulePeriodic;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

@BenderBindAllFields
@Value
public class TaskTimingConfig {
    int timeoutInMinutes;
    int periodInMinutes;

    public TaskTimingConfig(int timeoutInMinutes, int periodInMinutes) {
        this.timeoutInMinutes = timeoutInMinutes;
        this.periodInMinutes = periodInMinutes;
    }

    public Duration getTimeout() {
        return Duration.standardMinutes(timeoutInMinutes);
    }

    public SchedulePeriodic getPeriod() {
        return new SchedulePeriodic(Duration.standardMinutes(periodInMinutes));
    }
}
