package ru.yandex.calendar.frontend.worker;

import java.util.concurrent.TimeUnit;

import io.micrometer.core.instrument.MeterRegistry;
import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.commune.bazinga.impl.worker.TaskExecutorMetrics;
import ru.yandex.misc.monica.core.name.MetricName;
import ru.yandex.misc.monica.util.measure.MeasureInfo;

public class UnistatWorkerTaskExecutionMetrics implements TaskExecutorMetrics {
    private final static String WORKER_COUNTER_METRIC_PREFIX = "application.worker";
    private final static String WORKER_TIMER_METRIC_PREFIX = "application.worker.time";
    @Autowired
    private MeterRegistry registry;

    private String getStatus(MeasureInfo info) {
        return info.isSuccessful() ? "success" : "error";
    }

    private void incrementScheduleErrors(String taskName) {
        registry.counter(StreamEx.of(WORKER_COUNTER_METRIC_PREFIX, taskName, "schedule.error").joining("."))
                .increment();
    }

    @Override
    public void updateOnetimeInvocations(MeasureInfo info, ListF<MetricName> names) {
        names.stream().forEach(metricName ->
                registry.counter(StreamEx.of(WORKER_COUNTER_METRIC_PREFIX, metricName, getStatus(info)).joining("."))
                        .increment());
    }

    @Override
    public void updateOnetimeTimeFromSchedule(long ms, MetricName name) {
        registry.timer(StreamEx.of(WORKER_TIMER_METRIC_PREFIX, name).joining("."))
                .record(ms, TimeUnit.MILLISECONDS);
    }

    @Override
    public void updateCronInvocations(MeasureInfo info, ListF<MetricName> names) {
        names.stream().forEach(metricName -> {
                    registry.counter(StreamEx.of(WORKER_COUNTER_METRIC_PREFIX, metricName, getStatus(info)).joining("."))
                            .increment();
                    registry.timer(StreamEx.of(WORKER_TIMER_METRIC_PREFIX, metricName).joining("."))
                            .record(info.elapsed().getMillis(), TimeUnit.MILLISECONDS);
                });

    }

    @Override
    public void incrementCronInvocationsCount(ListF<MetricName> names) {
        names.stream().forEach(metricName ->
                registry.counter(StreamEx.of(WORKER_COUNTER_METRIC_PREFIX, metricName).joining("."))
                        .increment());
    }

    @Override
    public void incrementOnetimeRetries(String taskName) {
        registry.counter(StreamEx.of(WORKER_COUNTER_METRIC_PREFIX, taskName, "retry").joining(".")).increment();
    }

    @Override
    public void incrementCronJobScheduleErrors(String taskName) {
        incrementScheduleErrors(taskName);
    }

    @Override
    public void incrementCronJobScheduleErrorsTotalCounter() {
        registry.counter(StreamEx.of(WORKER_COUNTER_METRIC_PREFIX, "cron.job.schedule.error").joining("."))
                .increment();
    }

    @Override
    public void incrementOnetimeJobScheduleErrors(String taskName) {
        incrementScheduleErrors(taskName);
    }

    @Override
    public void incrementOnetimeJobScheduleErrorsTotalCounter() {
        registry.counter(StreamEx.of(WORKER_COUNTER_METRIC_PREFIX, "onetime.job.schedule.error").joining("."))
                .increment();
    }
}
