package ru.yandex.calendar.frontend.worker;

import javax.annotation.PostConstruct;

import io.micrometer.core.instrument.MeterRegistry;
import lombok.extern.java.Log;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.domain.PassportAuthDomainsHolder;
import ru.yandex.commune.bazinga.BazingaMonitoringManager;

@Log
public class WorkerMetrics {
    @Autowired
    private PassportAuthDomainsHolder passportAuthDomainsHolder;

    @Autowired
    BazingaMonitoringManager bazingaMonitoringManager;

    @Autowired
    MeterRegistry registry;

    public static final String CRON_DAY_METRICS_PREFIX = "worker.cron.day";
    public static final String CRON_WEEK_METRICS_PREFIX = "worker.cron.wek";
    public static final ListF<String> DAILY_CRON_TASK_NAMES = Cf.list(
            "updateAbsencesFromStaff",
            "cleanBigMaterializedEvents",
            "cleanEventsLog",
            "cleanResourceReservations",
            "cleanResourceSchedule",
            "compareAllResources",
            "ewsAllSynch",
            "ewsDesyncMonitoring",
            "ewsExportResourceMeetings",
            "ewsPull",
            "ewsResubscribe",
            "ewsSynch",
            "recalculateAndSendNotifications",
            "reportBrokenDisplays",
            "sendRepetitionConfirmationEmailsAndKillUnconfirmed",
            "sendSmsNotifications",
            "staffSynchronizer",
            "updateAbsencesFromStaff",
            "updateResourcesFromCenter",
            "updateSettingsFromCenter"
    );
    public static final ListF<String> WEEKLY_CRON_TASK_NAMES = Cf.list(
            "ewsUnsubscribeDismissedUsers",
            "sendMassageSchedule",
            "sendPsychotherapistSchedule"
    );


    @PostConstruct
    public void setUp() {
        if (passportAuthDomainsHolder.containsYandexTeamRu()) {
            DAILY_CRON_TASK_NAMES.forEach(taskName -> {
                registry.gauge(
                        CRON_DAY_METRICS_PREFIX + "." + taskName,
                        bazingaMonitoringManager,
                        (manager) -> manager.getCronTaskSuccessPercentForDay(taskName)
                );
            });
            WEEKLY_CRON_TASK_NAMES.forEach(taskName -> {
                registry.gauge(
                        CRON_WEEK_METRICS_PREFIX + "." + taskName,
                        bazingaMonitoringManager,
                        (manager) -> manager.getCronTaskSuccessPercentForWeek(taskName)
                );
            });
        }
    }
}
