package ru.yandex.calendar.frontend.worker;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.calendar.frontend.worker.task.CleanEventsLogTask;
import ru.yandex.calendar.frontend.worker.task.IcsImportTask;
import ru.yandex.calendar.frontend.worker.task.SendMailTask;
import ru.yandex.calendar.frontend.worker.task.SendTodoMailTask;
import ru.yandex.calendar.frontend.worker.task.TaskCleanMessageExtra;
import ru.yandex.calendar.frontend.worker.task.TaskRecalculateAndSendNotifications;
import ru.yandex.calendar.frontend.worker.task.TelemostGenerateTask;
import ru.yandex.calendar.frontend.worker.task.UpdateIcsFeedTask;
import ru.yandex.calendar.frontend.worker.task.UpdateLayersTimestampsTask;

@Configuration
@Import({
        WorkerTasksYtContextConfiguration.class,
})
public class WorkerTasksContextConfiguration {
    @Bean
    public TaskRecalculateAndSendNotifications taskRecalculateAndSendNotifications() {
        return new TaskRecalculateAndSendNotifications();
    }

    @Bean
    public SendMailTask sendMailTask() {
        return new SendMailTask();
    }

    @Bean
    public SendTodoMailTask sendTodoMailTask() {
        return new SendTodoMailTask();
    }

    @Bean
    public UpdateIcsFeedTask updateIcsFeedTask() {
        return new UpdateIcsFeedTask();
    }

    @Bean
    public UpdateLayersTimestampsTask updateLayersTimestampsTask() {
        return new UpdateLayersTimestampsTask();
    }

    @Bean
    public IcsImportTask icsImportTask() {
        return new IcsImportTask();
    }

    @Bean
    public CleanEventsLogTask cleanEventsLogTask() {
        return new CleanEventsLogTask();
    }

    @Bean
    public TelemostGenerateTask telemostGenerateTask() {
        return new TelemostGenerateTask();
    }

    @Bean
    public TaskCleanMessageExtra taskCleanMessageExtra() {
        return new TaskCleanMessageExtra();
    }
}
