package ru.yandex.calendar.frontend.worker;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

import ru.yandex.calendar.frontend.worker.task.AttendeeToSubscriberTask;
import ru.yandex.calendar.frontend.worker.task.CleanBigMaterializedEventsTask;
import ru.yandex.calendar.frontend.worker.task.EwsExportEventResourceChangesOnUpdateTask;
import ru.yandex.calendar.frontend.worker.task.HandleMailAttachTask;
import ru.yandex.calendar.frontend.worker.task.SendMassageScheduleTask;
import ru.yandex.calendar.frontend.worker.task.SendPsychotherapistScheduleTask;
import ru.yandex.calendar.frontend.worker.task.StaffSynchronizerTask;
import ru.yandex.calendar.frontend.worker.task.TaskAllEwsersDesyncMonitoring;
import ru.yandex.calendar.frontend.worker.task.TaskCleanResourceReservations;
import ru.yandex.calendar.frontend.worker.task.TaskCleanResourceSchedule;
import ru.yandex.calendar.frontend.worker.task.TaskCommonLayersCheck;
import ru.yandex.calendar.frontend.worker.task.TaskCompareAllResources;
import ru.yandex.calendar.frontend.worker.task.TaskEwsAllSynch;
import ru.yandex.calendar.frontend.worker.task.TaskEwsDesyncMonitoring;
import ru.yandex.calendar.frontend.worker.task.TaskEwsExportResourceMeetings;
import ru.yandex.calendar.frontend.worker.task.TaskEwsPull;
import ru.yandex.calendar.frontend.worker.task.TaskEwsResubscribe;
import ru.yandex.calendar.frontend.worker.task.TaskEwsSynch;
import ru.yandex.calendar.frontend.worker.task.TaskEwsUnsubscribeDismissedUsers;
import ru.yandex.calendar.frontend.worker.task.TaskReportBrokenDisplays;
import ru.yandex.calendar.frontend.worker.task.TaskSendRepetitionConfirmationEmailsAndKillUnconfirmed;
import ru.yandex.calendar.frontend.worker.task.TaskSendSmsNotifications;
import ru.yandex.calendar.frontend.worker.task.TaskUpdateAbsencesFromStaff;
import ru.yandex.calendar.frontend.worker.task.TaskUpdateResourcesFromCenter;
import ru.yandex.calendar.frontend.worker.task.TaskUpdateSettingsFromCenter;
import ru.yandex.calendar.util.spring.YandexTeamCondition;
import ru.yandex.commune.dynproperties.DynamicPropertyRegistry;

/**
 * @author dbrylev
 */
@Configuration
@Conditional(YandexTeamCondition.class)
public class WorkerTasksYtContextConfiguration {

    @Bean
    public TaskCompareAllResources taskCompareAllResources() {
        return new TaskCompareAllResources();
    }

    @Bean
    public TaskEwsResubscribe taskEwsResubscribe() {
        return new TaskEwsResubscribe();
    }

    @Bean
    public TaskEwsUnsubscribeDismissedUsers taskEwsUnsubscribeDismissedUsers() {
        return new TaskEwsUnsubscribeDismissedUsers();
    }

    @Bean
    public TaskEwsExportResourceMeetings taskEwsExportResourceMeetings() {
        return new TaskEwsExportResourceMeetings();
    }

    @Bean
    public TaskUpdateSettingsFromCenter taskUpdateSettingsFromStaff() {
        return new TaskUpdateSettingsFromCenter();
    }

    @Bean
    public TaskUpdateResourcesFromCenter taskUpdateResourcesFromCenter() {
        return new TaskUpdateResourcesFromCenter();
    }

    @Bean
    public TaskUpdateAbsencesFromStaff taskUpdateAbsencesFromStaff() {
        return new TaskUpdateAbsencesFromStaff();
    }

    @Bean
    public TaskCleanResourceReservations taskCleanResourceReservations() {
        return new TaskCleanResourceReservations();
    }

    @Bean
    public TaskCleanResourceSchedule taskCleanResourceSchedule() {
        return new TaskCleanResourceSchedule();
    }

    @Bean
    public TaskSendSmsNotifications taskSendSmsNotifications() {
        return new TaskSendSmsNotifications();
    }

    @Bean
    public TaskSendRepetitionConfirmationEmailsAndKillUnconfirmed taskSendRepetitionConfirmationEmailsAndKillUnconfirmed() {
        return new TaskSendRepetitionConfirmationEmailsAndKillUnconfirmed();
    }

    @Bean
    public TaskEwsSynch taskEwsSynch() {
        return new TaskEwsSynch();
    }

    @Bean
    public TaskEwsAllSynch taskEwsAllSynch() {
        return new TaskEwsAllSynch();
    }

    @Bean
    public TaskEwsPull taskEwsPull() {
        return new TaskEwsPull();
    }

    @Bean
    public TaskReportBrokenDisplays taskReportBrokenDisplays() {
        return new TaskReportBrokenDisplays();
    }

    @Bean
    public TaskEwsDesyncMonitoring taskEwsDesyncMonitoring() {
        return new TaskEwsDesyncMonitoring();
    }

    @Bean
    public TaskAllEwsersDesyncMonitoring taskAllEwsersDesyncMonitoring() {
        return new TaskAllEwsersDesyncMonitoring();
    }

    @Bean
    public CleanBigMaterializedEventsTask cleanBigMaterializedEventsTask() {
        return new CleanBigMaterializedEventsTask();
    }

    @Bean
    public AttendeeToSubscriberTask attendeeToSubscriberTask() {
        return new AttendeeToSubscriberTask();
    }

    @Bean
    public TaskCommonLayersCheck taskCommonLayersCheck() {
        return new TaskCommonLayersCheck();
    }

    @Bean
    public EwsExportEventResourceChangesOnUpdateTask ewsExportEventChangesOnUpdateTask() {
        return new EwsExportEventResourceChangesOnUpdateTask();
    }

    @Bean
    public StaffSynchronizerTask staffSynchronizerTask() {
        return new StaffSynchronizerTask();
    }

    @Bean
    public SendMassageScheduleTask sendMassageScheduleTask() {
        return new SendMassageScheduleTask();
    }

    @Bean
    public SendPsychotherapistScheduleTask sendPsychotherapistScheduleTask() {
        return new SendPsychotherapistScheduleTask();
    }

    @Bean
    public TaskConfigurationHolder taskConfigurationHolder(DynamicPropertyRegistry registry) {
        registry.addStaticFields(TaskConfigurationHolder.class);
        return new TaskConfigurationHolder();
    }

    @Bean
    public HandleMailAttachTask handleMailAttachTask() {
        return new HandleMailAttachTask();
    }
}
