package ru.yandex.calendar.frontend.worker.task;

import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * Task for periodically transferring all participants to subscribers,
 * except for the specified ones.
 *
 * @author Stepan Kladikov
 */

@BenderBindAllFields
public class AttendeeToSubscriberTaskResult {
    public int failed = 0;
    public int moved = 0;
    public int skipped = 0;

    void registerSkipped() {
        skipped++;
    }

    void registerResult(boolean isSuccess) {
        if (isSuccess) {
            moved++;
        } else {
            failed++;
        }
    }
}
