package ru.yandex.calendar.frontend.worker.task;

import lombok.extern.slf4j.Slf4j;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.frontend.worker.CalendarCronTask;
import ru.yandex.calendar.logic.event.ActionInfo;
import ru.yandex.calendar.logic.event.ActorId;
import ru.yandex.calendar.logic.event.EventRoutines;
import ru.yandex.calendar.logic.event.dao.EventUserDao;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.SchedulePeriodic;

@Slf4j
public class CleanBigMaterializedEventsTask extends CalendarCronTask {

    @Autowired
    private EventRoutines eventRoutines;

    @Autowired
    private EventUserDao eventUserDao;

    @Override
    public Duration timeout() {
        return Duration.standardHours(3);
    }

    @Override
    public Schedule cronExpression() {
        return new SchedulePeriodic(Duration.standardDays(7));
    }

    @Override
    public void doExecute(ExecutionContext executionContext) throws Exception {
        Long dayToLookBack = 30L;
        Long participantsLimit = 100L;
        Instant upperTimeLimit = Instant.now().minus(Duration.standardDays(dayToLookBack));
        ListF<Long> bigMeetingsEventsIds = eventUserDao.findBigMeetings(participantsLimit, upperTimeLimit);
        log.debug("About to delete {} old big materialized events older than {} days with more than {} attendees.", bigMeetingsEventsIds.size(), dayToLookBack, participantsLimit);
        eventRoutines.deleteEvents(ActorId.yaCalendar(), bigMeetingsEventsIds, ActionInfo.adminManager(), true, false);
        log.debug("Deleted {} old big materialized events older than {} days with more than {} attendees.", bigMeetingsEventsIds.size(), dayToLookBack, participantsLimit);
    }
}
