package ru.yandex.calendar.frontend.worker.task;

import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.frontend.worker.CalendarCronTask;
import ru.yandex.calendar.logic.log.dao.EventsLogDao;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.SchedulePeriodic;

@Slf4j
public class CleanEventsLogTask extends CalendarCronTask {
    @Autowired
    private EventsLogDao eventsLogDao;

    @Override
    public Schedule cronExpression() {
        return new SchedulePeriodic(Duration.standardHours(1));
    }

    @Override
    public void doExecute(ExecutionContext executionContext) {
        log.info("Events log garbage collection started");
        val start = System.currentTimeMillis();
        val deletedCount = eventsLogDao.gc();
        log.info("Events log garbage collection finished in {} ms and deleted {} rows", System.currentTimeMillis() - start, deletedCount);
    }
}
