package ru.yandex.calendar.frontend.worker.task;

import java.util.Optional;

import lombok.Value;
import lombok.val;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.calendar.frontend.ews.exp.EwsExportRoutines;
import ru.yandex.calendar.frontend.ews.exp.OccurrenceId;
import ru.yandex.calendar.frontend.ews.exp.ResourceParticipantChangesInfo;
import ru.yandex.calendar.frontend.worker.CalendarOnetimeTask;
import ru.yandex.calendar.frontend.worker.EwsExportTaskConverter;
import ru.yandex.calendar.logic.beans.generated.Event;
import ru.yandex.calendar.logic.beans.generated.Repetition;
import ru.yandex.calendar.logic.event.ActionInfo;
import ru.yandex.calendar.logic.event.ActionSource;
import ru.yandex.calendar.logic.event.EventChangesInfoForExchange;
import ru.yandex.commune.bazinga.scheduler.ActiveUniqueIdentifierConverter;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.schedule.RescheduleLinear;
import ru.yandex.commune.bazinga.scheduler.schedule.ReschedulePolicy;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

public class EwsExportEventResourceChangesOnUpdateTask
        extends CalendarOnetimeTask<EwsExportEventResourceChangesOnUpdateTask.ExportToExchangeTaskParameters>
{
    private static final EventChangesInfoForExchange EVENT_CHANGES_INFO_FOR_EXCHANGE
            = new EventChangesInfoForExchange(new Event(), new Repetition(), true, Cf.list());

    @Autowired
    private EwsExportRoutines ewsExportRoutines;

    public EwsExportEventResourceChangesOnUpdateTask() {
        super(ExportToExchangeTaskParameters.class);
    }

    protected EwsExportEventResourceChangesOnUpdateTask(ExportToExchangeTaskParameters parameters) {
        super(parameters);
    }

    protected EwsExportEventResourceChangesOnUpdateTask(Class<ExportToExchangeTaskParameters> parametersClass) {
        super(parametersClass);
    }

    public EwsExportEventResourceChangesOnUpdateTask(long eventId, ResourceParticipantChangesInfo resourceChanges,
                                                     Optional<OccurrenceId> occurrenceId, ActionInfo actionInfo) {
        this(new ExportToExchangeTaskParameters(eventId, resourceChanges, occurrenceId, actionInfo.getActionSource(), actionInfo.getRequestId()));
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(1);
    }

    @Override
    public Class<? extends ActiveUniqueIdentifierConverter<?, ?>> getActiveUidConverter() {
        return EwsExportTaskConverter.class;
    }


    @Override
    public ReschedulePolicy reschedulePolicy() {
        return new RescheduleLinear(Duration.standardMinutes(1), 8);
    }

    @Override
    protected void doExecute(ExportToExchangeTaskParameters parameters, ExecutionContext context) throws Exception {
        val jobId = context.getFullJobId().getJobId().getUuid();
        val actionInfo = new ActionInfo("", parameters.source, parameters.rid + "/" + jobId, Instant.now());
        ewsExportRoutines.exportToExchangeIfNeededOnUpdate(
                EVENT_CHANGES_INFO_FOR_EXCHANGE, parameters.occurrenceId, parameters.eventId, parameters.resourceParticipantChangesInfo, actionInfo);
    }

    @Value
    @BenderBindAllFields
    public static class ExportToExchangeTaskParameters {
        long eventId;
        ResourceParticipantChangesInfo resourceParticipantChangesInfo;
        Optional<OccurrenceId> occurrenceId;
        ActionSource source;
        String rid;
    }
}
