package ru.yandex.calendar.frontend.worker.task;

import org.joda.time.Duration;
import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.frontend.worker.CalendarOnetimeTask;
import ru.yandex.calendar.logic.event.ActionInfo;
import ru.yandex.calendar.logic.event.ActionSource;
import ru.yandex.calendar.logic.mailer.MailerHandler;
import ru.yandex.calendar.logic.mailer.logbroker.MailAttach;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.CompoundReschedulePolicy;
import ru.yandex.commune.bazinga.scheduler.schedule.RescheduleConstant;
import ru.yandex.commune.bazinga.scheduler.schedule.RescheduleExponential;
import ru.yandex.commune.bazinga.scheduler.schedule.ReschedulePolicy;
import ru.yandex.misc.log.reqid.RequestIdStack;

/**
 * @author dbrylev
 */
public class HandleMailAttachTask extends CalendarOnetimeTask<MailAttach> {

    public static final TaskQueueName QUEUE_NAME = new TaskQueueName("mailhook");

    @Autowired
    private MailerHandler mailerHandler;

    public HandleMailAttachTask(MailAttach attach) {
        super(attach);
    }

    public HandleMailAttachTask() {
        super(MailAttach.class);
    }

    @Override
    protected void doExecute(MailAttach parameters, ExecutionContext context) throws Exception {
        ActionInfo actionInfo = new ActionInfo(
                ActionSource.WORKER, RequestIdStack.current().getOrThrow("no request id!"), Instant.now());

        mailerHandler.handleAttach(parameters, actionInfo);
    }

    @Override
    public ReschedulePolicy reschedulePolicy() {
        return new CompoundReschedulePolicy(
                new RescheduleConstant(Duration.standardSeconds(20), 6),
                new RescheduleConstant(Duration.standardMinutes(1), 8),
                new RescheduleExponential(Duration.standardMinutes(2), 10));
    }

    @Override
    public TaskQueueName queueName() {
        return QUEUE_NAME;
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(5);
    }
}
