package ru.yandex.calendar.frontend.worker.task;

import io.micrometer.core.instrument.MeterRegistry;
import lombok.extern.slf4j.Slf4j;
import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import ru.yandex.calendar.frontend.worker.CalendarCronTask;
import ru.yandex.calendar.frontend.worker.TaskConfigurationHolder;
import ru.yandex.calendar.logic.domain.PassportAuthDomainsHolder;
import ru.yandex.calendar.logic.staff.DefaultStaffHttpProvider;
import ru.yandex.calendar.logic.staff.StaffSynchronizer;
import ru.yandex.calendar.logic.staff.StaffV3;
import ru.yandex.calendar.util.HttpClientConfiguration;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.inside.utils.AuthenticatingClient;
import ru.yandex.inside.utils.OAuthAuthenticationHandler;


@Slf4j
public class StaffSynchronizerTask extends CalendarCronTask {

    public static final TaskQueueName QUEUE_NAME = new TaskQueueName("staff-sync");

    @Autowired
    StaffSynchronizer staffSynchronizer;
    @Value("${yt.staff.token:-}")
    private String staffApiToken;
    @Value("${yt.staffV3.url}")
    private String staffUrl;
    @Autowired
    private MeterRegistry meterRegistry;
    @Autowired
    private PassportAuthDomainsHolder passportAuthDomainsHolder;
    @Autowired
    private TaskConfigurationHolder configHolder;


    @Override
    public Duration timeout() {
        return configHolder.config("staffSynchronizer").getTimeout();
    }

    @Override
    public Schedule cronExpression() {
        return configHolder.config("staffSynchronizer").getPeriod();
    }

    @Override
    public void doExecute(ExecutionContext executionContext) {
        if (passportAuthDomainsHolder.containsYandexTeamRu()) {
            var httpConf = HttpClientConfiguration.fromProperties("yt.center");
            var httpClient = httpConf.consTrustAllClient(meterRegistry, "staff");
            staffSynchronizer.synchronize(new StaffV3(staffUrl, new DefaultStaffHttpProvider(staffApiToken,
                    new AuthenticatingClient(httpClient, new OAuthAuthenticationHandler(staffApiToken)))));

        }
    }

    @Override
    public TaskQueueName queueName() {
        return QUEUE_NAME;
    }
}
