package ru.yandex.calendar.frontend.worker.task;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.boot.EwsAliveHandler;
import ru.yandex.calendar.frontend.worker.CalendarCronTask;
import ru.yandex.calendar.monitoring.AllEwsersDesyncDynamicMonitoring;
import ru.yandex.commune.bazinga.impl.TaskId;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleCron;
import ru.yandex.misc.time.TimeUtils;

public class TaskAllEwsersDesyncMonitoring extends CalendarCronTask {
    public static final String CRON_EXPRESSION = "0 2 * * *";
    @Autowired
    private AllEwsersDesyncDynamicMonitoring allEwsersDesyncDynamicMonitoring;
    @Autowired
    private EwsAliveHandler ewsAliveHandler;

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(120);
    }

    @Override
    public Schedule cronExpression() {
        return ScheduleCron.parse(CRON_EXPRESSION, TimeUtils.EUROPE_MOSCOW_TIME_ZONE);
    }

    @Override
    public void doExecute(ExecutionContext executionContext) throws Exception {
        if (ewsAliveHandler.isEwsAlive()) {
            allEwsersDesyncDynamicMonitoring.execute(executionContext, new TaskId("allEwsersDesyncMonitoring"));
        }
    }
}
