package ru.yandex.calendar.frontend.worker.task;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.frontend.worker.CalendarCronTask;
import ru.yandex.calendar.logic.sending.bazinga.MessageExtraDao;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.SchedulePeriodic;

public class TaskCleanMessageExtra extends CalendarCronTask {

    @Autowired
    private MessageExtraDao messageExtraDao;

    @Override
    public Schedule cronExpression() {
        return new SchedulePeriodic(Duration.standardHours(1));
    }

    @Override
    protected void doExecute(ExecutionContext executionContext) throws Exception {
        messageExtraDao.deleteExpired();
    }
}
