package ru.yandex.calendar.frontend.worker.task;

import org.joda.time.Duration;
import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.frontend.worker.CalendarCronTask;
import ru.yandex.calendar.logic.resource.reservation.ResourceReservationManager;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.SchedulePeriodic;

/**
 * @author dbrylev
 */
public class TaskCleanResourceReservations extends CalendarCronTask {

    @Autowired
    private ResourceReservationManager resourceReservationManager;

    @Override
    public Schedule cronExpression() {
        return new SchedulePeriodic(Duration.standardMinutes(5));
    }

    @Override
    public void doExecute(ExecutionContext executionContext) throws Exception {
        resourceReservationManager.deleteReservationsDeadlinedBefore(Instant.now());
    }
}
