package ru.yandex.calendar.frontend.worker.task;

import org.joda.time.Duration;
import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.frontend.worker.CalendarCronTask;
import ru.yandex.calendar.logic.resource.schedule.ResourceScheduleDao;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.SchedulePeriodic;

/**
 * @author dbrylev
 */
public class TaskCleanResourceSchedule extends CalendarCronTask {

    @Autowired
    private ResourceScheduleDao resourceScheduleDao;

    @Override
    public Schedule cronExpression() {
        return new SchedulePeriodic(Duration.standardHours(1));
    }

    @Override
    public void doExecute(ExecutionContext executionContext) throws Exception {
        resourceScheduleDao.deleteResourceSchedulesStartedBefore(Instant.now().minus(Duration.standardDays(8)));
    }
}
