package ru.yandex.calendar.frontend.worker.task;

import java.util.Map;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.frontend.worker.CalendarCronTask;
import ru.yandex.calendar.logic.layer.common.CheckerConfig;
import ru.yandex.calendar.logic.layer.common.CommonLayersChecker;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleCron;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.time.TimeUtils;

public class TaskCommonLayersCheck extends CalendarCronTask {
    private static final Logger logger = LoggerFactory.getLogger(TaskCommonLayersCheck.class);

    public static final String CRON_EXPRESSION = "0 0 * * *";

    private final DynamicProperty<CheckerConfig> config =
            new DynamicProperty<>("commonLayers", new CheckerConfig(7, Map.of()));

    @Autowired
    private CommonLayersChecker commonLayersChecker;

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(120);
    }

    @Override
    public Schedule cronExpression() {
        return ScheduleCron.parse(CRON_EXPRESSION, TimeUtils.EUROPE_MOSCOW_TIME_ZONE);
    }

    @Override
    public void doExecute(ExecutionContext executionContext) throws Exception {
        logger.info(config);
        commonLayersChecker.execute(config.get());
    }
}
