package ru.yandex.calendar.frontend.worker.task;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.boot.EwsAliveHandler;
import ru.yandex.calendar.frontend.ews.compare.EwsComparator;
import ru.yandex.calendar.frontend.ews.compare.EwsCompareResult;
import ru.yandex.calendar.frontend.worker.CalendarCronTask;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.SchedulePeriodic;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author ssytnik
 */
public class TaskCompareAllResources extends CalendarCronTask {
    private static final Logger logger = LoggerFactory.getLogger(TaskCompareAllResources.class);

    @Autowired
    private EwsComparator ewsComparator;
    @Autowired
    private EwsAliveHandler ewsAliveHandler;

    @Override
    public Schedule cronExpression() {
        return new SchedulePeriodic(Duration.standardHours(2));
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(30);
    }

    @Override
    public void doExecute(ExecutionContext executionContext) throws Exception {
        if (!ewsAliveHandler.isEwsAlive()) return;
        ListF<EwsCompareResult> results = ewsComparator.compareAllResourcesSafe();
        ListF<EwsCompareResult> diffs = results.filter(EwsCompareResult.hasDiffsF());
        if (diffs.isNotEmpty()) {
            logger.info("Differences: " + diffs.mkString("\n"));
        }
        logger.info("Total resources: " + results.size() + ", has diffs: " + diffs.size());
        logger.info(
                "Total keys: common: " +
                results.map(EwsCompareResult.getCommonKeysSizeF()).foldLeft(0, Cf.Integer.plusF()) +
                ", exchange unique: " +
                results.map(EwsCompareResult.getExchangeUniqueKeysSizeF()).foldLeft(0, Cf.Integer.plusF()) +
                ", calendar unique: decided: " +
                results.map(EwsCompareResult.getCalendarUniqueKeysSizeF()).foldLeft(0, Cf.Integer.plusF())
                );
    }

}
