package ru.yandex.calendar.frontend.worker.task;

import org.joda.time.Duration;

import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.SchedulePeriodic;

public class TaskEwsAllSynch extends TaskEwsSynch {
    @Override
    public Schedule cronExpression() {
        return new SchedulePeriodic(Duration.standardHours(2));
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(119);
    }

    @Override
    public void doExecute(ExecutionContext executionContext) throws Exception {
        if (passportAuthDomainsHolder.containsYandexTeamRu() && ewsAliveHandler.isEwsAlive()) {
            ewsEventsSynchronizer.synchronizeAll(false, false, true);
        }
    }
}
