package ru.yandex.calendar.frontend.worker.task;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.boot.EwsAliveHandler;
import ru.yandex.calendar.frontend.worker.CalendarCronTask;
import ru.yandex.calendar.monitoring.EwsDesyncDynamicMonitoring;
import ru.yandex.commune.bazinga.impl.TaskId;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.SchedulePeriodic;

public class TaskEwsDesyncMonitoring extends CalendarCronTask {
    public static final Duration PERIOD = Duration.standardMinutes(15);
    @Autowired
    private EwsDesyncDynamicMonitoring ewsDesyncDynamicMonitoring;
    @Autowired
    private EwsAliveHandler ewsAliveHandler;

    @Override
    public Schedule cronExpression() {
        return new SchedulePeriodic(PERIOD);
    }

    @Override
    public void doExecute(ExecutionContext executionContext) throws Exception {
        if (ewsAliveHandler.isEwsAlive()) {
            ewsDesyncDynamicMonitoring.execute(executionContext, new TaskId("ewsDesyncMonitoring"));
        }
    }
}
