package ru.yandex.calendar.frontend.worker.task;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.boot.EwsAliveHandler;
import ru.yandex.calendar.frontend.ews.exp.async.EwsResourceMeetingExporter;
import ru.yandex.calendar.frontend.worker.CalendarCronTask;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleDelay;

/**
 * @author dbrylev
 */
public class TaskEwsExportResourceMeetings extends CalendarCronTask {
    @Autowired
    private EwsResourceMeetingExporter ewsResourceMeetingExporter;
    @Autowired
    private EwsAliveHandler ewsAliveHandler;

    @Override
    public Schedule cronExpression() {
        return new ScheduleDelay(Duration.standardSeconds(15));
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(15);
    }

    @Override
    public void doExecute(ExecutionContext executionContext) throws Exception {
        if (ewsAliveHandler.isEwsAlive()) {
            ewsResourceMeetingExporter.exportMeetings();
        }
    }
}
