package ru.yandex.calendar.frontend.worker.task;

import java.util.ArrayList;
import java.util.List;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.boot.EwsAliveHandler;
import ru.yandex.calendar.frontend.ews.subscriber.ExchangeSubscriber;
import ru.yandex.calendar.frontend.worker.CalendarCronTask;
import ru.yandex.calendar.logic.domain.PassportAuthDomainsHolder;
import ru.yandex.calendar.logic.user.SettingsRoutines;
import ru.yandex.calendar.monitoring.EwsMonitoring;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.SchedulePeriodic;
import ru.yandex.inside.passport.blackbox.PassportAuthDomain;
import ru.yandex.misc.email.Email;

public class TaskEwsResubscribe extends CalendarCronTask {
    @Autowired
    private PassportAuthDomainsHolder passportAuthDomainsHolder;
    @Autowired
    private ExchangeSubscriber exchangeSubscriber;
    @Autowired
    private EwsMonitoring ewsMonitoring;
    @Autowired
    private SettingsRoutines settingsRoutines;
    @Autowired
    private EwsAliveHandler ewsAliveHandler;

    @Override
    public Schedule cronExpression() {
        return new SchedulePeriodic(Duration.standardMinutes(5));
    }

    @Override
    public void doExecute(ExecutionContext executionContext) throws Exception {
        try {
            if (passportAuthDomainsHolder.containsYandexTeamRu() && ewsAliveHandler.isEwsAlive()) {
                exchangeSubscriber.resubscribeExpired();
                exchangeSubscriber.updateAllResourceSubscriptions();
                final ListF<Email> allEwserEmails = settingsRoutines.getAllEwserEmails();
                final List<Email> yaTeamEmails = new ArrayList<>();
                for (Email email : allEwserEmails) {
                    if (email.getDomain().equals(PassportAuthDomain.YANDEX_TEAM_RU.getDomain())) {
                        yaTeamEmails.add(email);
                    }
                }
                exchangeSubscriber.subscribeUsers(yaTeamEmails);
            }
        } catch (Exception e) {
            ewsMonitoring.reportIfEwsException(e);
            throw e;
        }
    }
}
