package ru.yandex.calendar.frontend.worker.task;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.boot.EwsAliveHandler;
import ru.yandex.calendar.frontend.ews.sync.EwsEventsSynchronizer;
import ru.yandex.calendar.frontend.worker.CalendarCronTask;
import ru.yandex.calendar.logic.domain.PassportAuthDomainsHolder;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.SchedulePeriodic;

/**
 * @author gutman
 */
public class TaskEwsSynch extends CalendarCronTask {

    @Autowired
    protected PassportAuthDomainsHolder passportAuthDomainsHolder;
    @Autowired
    protected EwsEventsSynchronizer ewsEventsSynchronizer;
    @Autowired
    protected EwsAliveHandler ewsAliveHandler;

    @Override
    public Schedule cronExpression() {
        return new SchedulePeriodic(Duration.standardHours(1));
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(59);
    }

    @Override
    public void doExecute(ExecutionContext executionContext) throws Exception {
        if (passportAuthDomainsHolder.containsYandexTeamRu() && ewsAliveHandler.isEwsAlive()) {
            ewsEventsSynchronizer.synchronizeAll(false, true, true);
        }
    }

}
