package ru.yandex.calendar.frontend.worker.task;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.frontend.ews.subscriber.ExchangeSubscriber;
import ru.yandex.calendar.frontend.worker.CalendarCronTask;
import ru.yandex.calendar.logic.domain.PassportAuthDomainsHolder;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleCron;
import ru.yandex.misc.time.MoscowTime;

/**
 * @author dbrylev
 */
public class TaskEwsUnsubscribeDismissedUsers extends CalendarCronTask {

    @Autowired
    private PassportAuthDomainsHolder passportAuthDomainsHolder;
    @Autowired
    private ExchangeSubscriber exchangeSubscriber;

    @Override
    public Schedule cronExpression() {
        return ScheduleCron.parse("0 10,22 * * *", MoscowTime.TZ);
    }

    @Override
    public void doExecute(ExecutionContext executionContext) throws Exception {
        exchangeSubscriber.unsubscribeDismissedUsers();
    }

}
