package ru.yandex.calendar.frontend.worker.task;

import org.joda.time.Duration;
import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.frontend.worker.CalendarCronTask;
import ru.yandex.calendar.logic.event.ActionInfo;
import ru.yandex.calendar.logic.event.ActionSource;
import ru.yandex.calendar.logic.notification.NotificationSendManager;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.SchedulePeriodic;
import ru.yandex.misc.log.reqid.RequestIdStack;

/**
 * @author gutman
 */
public class TaskRecalculateAndSendNotifications extends CalendarCronTask {

    @Autowired
    private NotificationSendManager notificationSendManager;

    @Override
    public Schedule cronExpression() {
        return new SchedulePeriodic(Duration.standardMinutes(5));
    }

    @Override
    public void doExecute(ExecutionContext executionContext) throws Exception {
        ActionInfo actionInfo = new ActionInfo(
                ActionSource.WORKER, RequestIdStack.current().getOrThrow("no request id!"), Instant.now());

        notificationSendManager.sendNotifications(actionInfo);
    }

}
