package ru.yandex.calendar.frontend.worker.task;

import org.joda.time.Duration;
import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.frontend.worker.CalendarCronTask;
import ru.yandex.calendar.logic.event.ActionInfo;
import ru.yandex.calendar.logic.event.ActionSource;
import ru.yandex.calendar.logic.event.repetition.RepetitionConfirmationManager;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.SchedulePeriodic;
import ru.yandex.misc.log.reqid.RequestIdStack;

/**
 * @author dbrylev
 */
public class TaskSendRepetitionConfirmationEmailsAndKillUnconfirmed extends CalendarCronTask {

    @Autowired
    private RepetitionConfirmationManager repetitionConfirmationManager;

    @Override
    public Schedule cronExpression() {
        return new SchedulePeriodic(Duration.standardHours(1));
    }

    @Override
    public void doExecute(ExecutionContext executionContext) throws Exception {
        ActionInfo actionInfo = new ActionInfo(
                ActionSource.WORKER, RequestIdStack.current().getOrThrow("no request id!"), Instant.now());

        repetitionConfirmationManager.sendConfirmationEmailsAndKillUnconfirmed(actionInfo);
    }
}
