package ru.yandex.calendar.frontend.worker.task;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.frontend.worker.CalendarCronTask;
import ru.yandex.calendar.frontend.worker.TaskConfigurationHolder;
import ru.yandex.calendar.logic.domain.PassportAuthDomainsHolder;
import ru.yandex.calendar.logic.event.avail.absence.AbsenceUpdater;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;

/**
 * @author gutman
 */
public class TaskUpdateAbsencesFromStaff extends CalendarCronTask {
    @Autowired
    private PassportAuthDomainsHolder passportAuthDomainsHolder;
    @Autowired
    private AbsenceUpdater absenceUpdater;
    @Autowired
    private TaskConfigurationHolder configHolder;

    @Override
    public Duration timeout() {
        return configHolder.config("updateAbsencesFromStaff").getTimeout();
    }

    @Override
    public Schedule cronExpression() {
        return configHolder.config("updateAbsencesFromStaff").getPeriod();
    }

    @Override
    public void doExecute(ExecutionContext executionContext) throws Exception {
        if (passportAuthDomainsHolder.containsYandexTeamRu()) {
            absenceUpdater.update();
        }
    }

}
