package ru.yandex.calendar.frontend.worker.task;

import lombok.extern.slf4j.Slf4j;
import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.frontend.worker.CalendarCronTask;
import ru.yandex.calendar.frontend.worker.TaskConfigurationHolder;
import ru.yandex.calendar.logic.domain.PassportAuthDomainsHolder;
import ru.yandex.calendar.logic.resource.center.CenterResourceUpdater;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;

@Slf4j
public class TaskUpdateResourcesFromCenter extends CalendarCronTask {
    @Autowired
    private CenterResourceUpdater centerResourceUpdater;
    @Autowired
    private PassportAuthDomainsHolder passportAuthDomainsHolder;
    @Autowired
    private TaskConfigurationHolder configHolder;

    @Override
    public Duration timeout() {
        return configHolder.config("updateResourcesFromCenter").getTimeout();
    }

    @Override
    public Schedule cronExpression() {
        return configHolder.config("updateResourcesFromCenter").getPeriod();
    }

    @Override
    public void doExecute(ExecutionContext executionContext) {
        if (passportAuthDomainsHolder.containsYandexTeamRu()) {
            log.info("Start updating staff resources from db");
            centerResourceUpdater.update();
            log.info("Staff resources updating completed successfully");
        }
    }
}
