package ru.yandex.calendar.frontend.worker.task;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.frontend.worker.CalendarCronTask;
import ru.yandex.calendar.frontend.worker.TaskConfigurationHolder;
import ru.yandex.calendar.logic.domain.PassportAuthDomainsHolder;
import ru.yandex.calendar.logic.user.CenterUserUpdater;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;

public class TaskUpdateSettingsFromCenter extends CalendarCronTask {
    @Autowired
    private PassportAuthDomainsHolder passportAuthDomainsHolder;
    @Autowired
    private CenterUserUpdater centerUserUpdater;
    @Autowired
    private TaskConfigurationHolder configHolder;

    @Override
    public Duration timeout() {
        return configHolder.config("updateSettingsFromCenter").getTimeout();
    }

    @Override
    public Schedule cronExpression() {
        return configHolder.config("updateSettingsFromCenter").getPeriod();
    }

    @Override
    public void doExecute(ExecutionContext executionContext) {
        if (passportAuthDomainsHolder.containsYandexTeamRu()) {
            centerUserUpdater.updateUsersSettingsFromCenter();
        }
    }
}
