package ru.yandex.calendar.frontend.worker.task;

import lombok.AllArgsConstructor;
import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.CalendarRequest;
import ru.yandex.calendar.frontend.worker.CalendarOnetimeTask;
import ru.yandex.calendar.logic.telemost.TelemostManager;
import ru.yandex.commune.bazinga.scheduler.ActiveUidBehavior;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDropType;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDuplicateBehavior;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.schedule.RescheduleExponential;
import ru.yandex.commune.bazinga.scheduler.schedule.ReschedulePolicy;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

public class TelemostGenerateTask extends CalendarOnetimeTask<TelemostGenerateTask.Parameters> {

    @Autowired
    private TelemostManager telemostManager;

    public TelemostGenerateTask() {
        super(Parameters.class);
    }

    public TelemostGenerateTask(long eventId) {
        super(new Parameters(eventId));
    }

    @Override
    protected void doExecute(Parameters parameters, ExecutionContext context) {
        telemostManager.generateLinkOrReschedule(parameters.eventId, CalendarRequest.getCurrent().getActionInfo());
    }

    @Override
    public ActiveUidBehavior activeUidBehavior() {
        return new ActiveUidBehavior(ActiveUidDropType.WHEN_RUNNING, ActiveUidDuplicateBehavior.DO_NOTHING);
    }

    @Override
    public ReschedulePolicy reschedulePolicy() {
        // about 2.5 hours
        return new RescheduleExponential(Duration.standardSeconds(10), 10);
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(5);
    }

    @Override
    public int priority() {
        return 0;
    }

    @BenderBindAllFields
    @AllArgsConstructor
    public static class Parameters {
        final long eventId;
    }
}
