package ru.yandex.calendar.frontend.xiva;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.calendar.frontend.xiva.v2.XivaHttpClient;
import ru.yandex.calendar.frontend.xiva.v2.XivaV2;
import ru.yandex.calendar.logic.XivaNotificationManager;
import ru.yandex.calendar.logic.notification.xiva.NotificationPreparedDataBuilder;
import ru.yandex.calendar.logic.notification.xiva.XivaNotificationNeedSendChecker;
import ru.yandex.calendar.logic.notification.xiva.XivaSendNotificationExecutor;
import ru.yandex.calendar.logic.notification.xiva.content.XivaNotificationEntityBuilder;
import ru.yandex.calendar.logic.notification.xiva.notify.XivaCommonManager;
import ru.yandex.calendar.logic.notification.xiva.notify.XivaMobileApiNotifier;
import ru.yandex.calendar.logic.notification.xiva.notify.XivaMobileEwsNotifier;
import ru.yandex.calendar.logic.notification.xiva.notify.XivaMobileReminderNotifier;

@Configuration
public class XivaContextConfiguration {
    @Bean
    public Xiva xiva() {
        return new Xiva();
    }

    @Bean
    public XivaMetrics xivaMetrics() {
        return new XivaMetrics();
    }

    @Bean
    public XivaHttpClient xivaHttpClient() {
        return new XivaHttpClient();
    }

    @Bean
    public XivaV2 xivaV2() {
        return new XivaV2();
    }

    @Bean
    public XivaNotificationNeedSendChecker xivaNotificationNeedSendChecker() {
        return new XivaNotificationNeedSendChecker();
    }

    @Bean
    public XivaNotificationEntityBuilder xivaNotificationPayloadBuilder() {
        return new XivaNotificationEntityBuilder();
    }

    @Bean
    public NotificationPreparedDataBuilder notificationPreparedDataBuilder() {
        return new NotificationPreparedDataBuilder();
    }

    @Bean
    public XivaNotificationManager xivaNotificationManager() {
        return new XivaNotificationManager();
    }

    @Bean
    public XivaSendNotificationExecutor xivaSendNotificationExecutor() {
        return new XivaSendNotificationExecutor();
    }

    @Bean
    public XivaCommonManager xivaCommonManager() {
        return new XivaCommonManager();
    }

    @Bean
    public XivaMobileApiNotifier xivaMobileApiNotifier() {
        return new XivaMobileApiNotifier();
    }

    @Bean
    public XivaMobileEwsNotifier xivaMobileEwsNotifier() {
        return new XivaMobileEwsNotifier();
    }

    @Bean
    public XivaMobileReminderNotifier xivaMobileReminderNotifier() {
        return new XivaMobileReminderNotifier();
    }
}
