package ru.yandex.calendar.frontend.xiva.v2.models;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.frontend.xiva.v2.models.payload.XivaPayload;
import ru.yandex.calendar.frontend.xiva.v2.models.repack.XivaRepack;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

@BenderBindAllFields
public class XivaEntity {
    private final XivaPayload payload;
    private final XivaRepack repack;
    private final ListF<String> tags;

    public XivaEntity(XivaPayload payload, XivaRepack repack, ListF<String> tags) {
        this.payload = payload;
        this.repack = repack;
        this.tags = tags;
    }

    public XivaPayload getPayload() {
        return payload;
    }

    public ListF<String> getTags() {
        return tags;
    }
}
