package ru.yandex.calendar.frontend.xiva.v2.models.repack;

import com.google.gson.annotations.SerializedName;

import ru.yandex.misc.bender.annotation.BenderBindAllFields;

@BenderBindAllFields
public class XivaRepackApnsAps {
    private final XivaRepackApnsAlert alert;
    private final String sound;
    private final int badge;
    @SerializedName("thread-id")
    private final String threadId;
    private final String category;
    @SerializedName("mutable-content")
    private final int mutableContent;

    public XivaRepackApnsAps(String title, String subtitle, String body) {
        this.alert = new XivaRepackApnsAlert(title, subtitle, body);
        this.sound = "default";
        this.badge = 0;
        this.threadId = "service-calendar";
        this.category = "default";
        this.mutableContent = 1;
    }
}
