package ru.yandex.calendar.frontend.yamb;

import java.util.function.Supplier;

import org.apache.http.HttpHeaders;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;

import ru.yandex.inside.utils.AuthenticationHandler;

/**
 * @url https://github.yandex-team.ru/pages/yamb/yamb-bots/api/bot/#avtorizatsiia
 *
 * @author dbrylev
 */
public class YambAuthenticationHandler implements AuthenticationHandler {

    private final Supplier<String> tokenProvider;

    public YambAuthenticationHandler(Supplier<String> tokenProvider) {
        this.tokenProvider = tokenProvider;
    }

    public YambAuthenticationHandler(String token) {
        this(() -> token);
    }

    @Override
    public HttpUriRequest handle(HttpRequest request) {
        HttpRequestWrapper wrapper = HttpRequestWrapper.wrap(request);
        wrapper.removeHeaders(HttpHeaders.AUTHORIZATION);
        wrapper.addHeader(HttpHeaders.AUTHORIZATION, "Token " + tokenProvider.get());
        return wrapper;
    }

    @Override
    public HttpContext handle(HttpContext context) {
        return context;
    }

}
