package ru.yandex.calendar.frontend.ywmi;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.util.email.Emails;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.email.Email;

/**
 * @author dbrylev
 */
@BenderBindAllFields
public class Address {
    public final String local;
    public final String domain;
    public final String displayName;

    public Address(String local, String domain, String displayName) {
        this.local = local;
        this.domain = domain;
        this.displayName = displayName;
    }

    public Email getEmail() {
        return Emails.punycode(local + "@" + domain);
    }

    public Option<Email> getEmailSafe() {
        return Emails.punycodeSafe(local + "@" + domain);
    }
}
