package ru.yandex.calendar.log;

import javax.annotation.Nullable;

import org.joda.time.Instant;

import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.email.Email;

/**
 * @author Stepan Koltsov
 */
public class LogMarker<T> {
    public static final LogMarker<Long> EVENT_ID = new LogMarker<Long>("event-id");
    public static final LogMarker<Instant> RECURRENCE_ID = new LogMarker<Instant>("recurrence-id");
    public static final LogMarker<Long> MAIN_EVENT_ID = new LogMarker<Long>("main-event-id");

    public static final LogMarker<String> ICS_METHOD = new LogMarker<String>("ics-method");
    public static final LogMarker<String> EXT_ID = new LogMarker<String>("ext-id");
    public static final LogMarker<String> EXCHANGE_ID = new LogMarker<String>("exchange-id");
    public static final LogMarker<String> ACTION_SOURCE = new LogMarker<String>("action-source");
    public static final LogMarker<String> ACTION = new LogMarker<String>("action");
    public static final LogMarker<String> MESSAGE_ID = new LogMarker<String>("message-id");
    public static final LogMarker<String> MESSAGE_FROM = new LogMarker<String>("message-from");
    public static final LogMarker<String> MESSAGE_TO = new LogMarker<String>("message-to");
    public static final LogMarker<String> POSTFIX_ID = new LogMarker<String>("postfix-id");

    // current user
    private static final LogMarker<PassportUid> CURRENT_USER_UID = new LogMarker<PassportUid>("current-user-uid");
    private static final LogMarker<Email> CURRENT_USER_EMAIL = new LogMarker<Email>("current-user-email");

    private final String name;
    private final String logId;

    private LogMarker(String name) {
        this.name = name;
        this.logId = name.toLowerCase().replace("_", "-");
    }

    public String format(@Nullable T param) {
        return "{" + logId + "=" + param + "}";
    }

    public static String currentUser(PassportUid uid, Email email) {
        return CURRENT_USER_UID.format(uid) + " " + CURRENT_USER_EMAIL.format(email);
    }

} //~
