package ru.yandex.calendar.logic.beans;

import java.util.UUID;

import org.joda.time.Instant;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

import ru.yandex.calendar.frontend.bender.InstantIso8601Marshaller;
import ru.yandex.calendar.frontend.bender.InstantIso8601Unmarshaller;
import ru.yandex.calendar.frontend.bender.LocalDateTimeNoMillisMarshaller;
import ru.yandex.calendar.frontend.bender.LocalDateTimeUnmarshaller;
import ru.yandex.calendar.frontend.bender.UnicodeEmailMarshaller;
import ru.yandex.calendar.frontend.bender.UnicodeEmailUnmarshaller;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactoryBuilder;
import ru.yandex.misc.bender.custom.UuidMarshaller;
import ru.yandex.misc.bender.custom.UuidUnmarshaller;
import ru.yandex.misc.bender.parse.simpleType.LocalDateUnmarshaller;
import ru.yandex.misc.bender.serialize.simpleType.LocalDateMarshaller;
import ru.yandex.misc.email.Email;

/**
 * @author dbrylev
 */
public class DatabaseBender {

    public static final BenderMapper mapper = new BenderMapper(getConfiguration());

    public static BenderConfiguration getConfiguration() {
        return BenderConfiguration.cons(
                MembersToBind.WITH_ANNOTATIONS, false,
                CustomMarshallerUnmarshallerFactoryBuilder.cons()
                        .add(Email.class, new UnicodeEmailMarshaller(), new UnicodeEmailUnmarshaller())
                        .add(LocalDateTime.class, new LocalDateTimeNoMillisMarshaller(), new LocalDateTimeUnmarshaller())
                        .add(LocalDate.class, new LocalDateMarshaller(), new LocalDateUnmarshaller())
                        .add(Instant.class, new InstantIso8601Marshaller(), new InstantIso8601Unmarshaller())
                        .add(UUID.class, new UuidMarshaller(), new UuidUnmarshaller())
                        .build());
    }
}
