package ru.yandex.calendar.logic.beans;


import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;

import org.springframework.jdbc.support.SqlValue;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function2;
import ru.yandex.misc.db.JdbcUtils;
import ru.yandex.misc.db.resultSet.ResultSetUtils;
import ru.yandex.misc.io.IoFunction;


/**
 * @author alexandr21
 */
public class IntegerArray implements SqlValue {
    private final ListF<Integer> elements;

    public IntegerArray() {
        this.elements = Cf.list();
    }

    public IntegerArray(int... elements) {
        this.elements = Cf.intList(elements);
    }

    public IntegerArray(ListF<Integer> list) {
        this.elements = list;
    }

    public ListF<Integer> getElements() {
        return this.elements;
    }

    public Integer get(int index) {
        return elements.get(index);
    }

    public Integer length() {
        return elements.length();
    }

    public static Function2<ResultSet, ResultSetUtils.ResultSetColumnAddress, IntegerArray> getF() {
        return ((rs, columnAddress) -> {
            try {
                return new IntegerArray(Cf.x((Integer[]) (columnAddress.getNameOrNumber().fold(
                        (IoFunction<String, Array>) rs::getArray,
                        (IoFunction<Integer, Array>) rs::getArray).getArray())));
            } catch (SQLException e) {
                throw JdbcUtils.translate(e);
            }
        });
    }

    @Override
    public void setValue(PreparedStatement ps, int paramIndex) throws SQLException {
        Array arr = ps.getConnection().createArrayOf("int", elements.toArray(Integer.class));
        ps.setObject(paramIndex, arr, Types.ARRAY);
    }

    @Override
    public void cleanup() {
    }
}
