package ru.yandex.calendar.logic.beans;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;

import org.springframework.cglib.core.internal.Function;
import org.springframework.jdbc.support.SqlValue;

import ru.yandex.bolts.function.Function2;
import ru.yandex.commune.bazinga.pg.storage.dao.support.JsonSqlValue;
import ru.yandex.misc.db.resultSet.ResultSetUtils;

/**
 * @author dbrylev
 */
public interface JsonizableValue extends SqlValue {
    String toDbValue();

    static <T> Function2<ResultSet, ResultSetUtils.ResultSetColumnAddress, T> getF(Function<String, T> parser) {
        return ResultSetUtils.getF(String.class).andThen(v -> v == null ? null : parser.apply(v));
    }

    @Override
    default void setValue(PreparedStatement ps, int paramIndex) throws SQLException {
        ps.setObject(paramIndex, JsonSqlValue.escapeJson(toDbValue()), Types.OTHER);
    }

    @Override
    default void cleanup() {
    }
}
