package ru.yandex.calendar.logic.beans;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author dbrylev
 */
public class NullableOtherValue<T> extends DefaultObject {
    public final Option<T> value;

    public NullableOtherValue(Option<T> value) {
        this.value = value;
    }

    public static <T> NullableOtherValue<T> some(T value) {
        return new NullableOtherValue<>(Option.of(value));
    }

    public static <T> NullableOtherValue<T> none() {
        return new NullableOtherValue<>(Option.empty());
    }

    public boolean isNull() {
        return !value.isPresent();
    }

    public T get() {
        return value.get();
    }

    public Option<T> asOption() {
        return value;
    }

    @Override
    public String toString() {
        return isNull() ? "NULL" : value.toString();
    }
}
