package ru.yandex.calendar.logic.beans;

import java.sql.ResultSet;

import ru.yandex.bolts.function.Function2;
import ru.yandex.commune.mapObject.db.type.DatabaseValueType;
import ru.yandex.misc.db.resultSet.ResultSetUtils;
import ru.yandex.misc.db.resultSet.ResultSetUtils.ResultSetColumnAddress;
import ru.yandex.misc.reflection.ClassX;
import ru.yandex.misc.reflection.FieldX;

/**
 * @author dbrylev
 */
public class NullableOtherValueType<T> extends DatabaseValueType<NullableOtherValue> {

    @SuppressWarnings("unchecked")
    public NullableOtherValueType(DatabaseValueType<T> type) {
        super(NullableOtherValue.class, newGetF1(type));
    }

    private static Function2<ResultSet, ResultSetColumnAddress, NullableOtherValue> newGetF1(DatabaseValueType<?> type) {
        Function2<ResultSet, ResultSetColumnAddress, ?> objectF = ResultSetUtils.getF(Object.class);
        Function2<ResultSet, ResultSetColumnAddress, ?> valueF = valueGetterF(type);

        return (rs, addr) -> {
            if (objectF.apply(rs, addr) == null) {
                return NullableOtherValue.none();
            } else {
                return NullableOtherValue.some(valueF.apply(rs, addr));
            }
        };
    }

    private static final FieldX databaseValueGetFField =
            ClassX.wrap(DatabaseValueType.class).getDeclaredField("getF").setAccessibleTrueReturnThis();

    @SuppressWarnings("unchecked")
    private static Function2<ResultSet, ResultSetColumnAddress, ?> valueGetterF(DatabaseValueType<?> type) {
        return (Function2<ResultSet, ResultSetColumnAddress, ?>) databaseValueGetFField.get(type);
    }
}
