package ru.yandex.calendar.logic.contact.addressbook;

import java.io.ByteArrayOutputStream;

import lombok.Getter;
import lombok.experimental.UtilityClass;

import ru.yandex.misc.bytes.ByteSequence;
import ru.yandex.misc.io.http.client.HttpResponseCallback;
import ru.yandex.misc.io.http.client.HttpResponseCallback200ToOutputStream;
import ru.yandex.misc.io.http.client.HttpResponseCallbackNoError;
import ru.yandex.misc.io.http.client.HttpResponseWithoutContent;

@UtilityClass
class HttpClientCallbacks {
    static class StatusCallback extends HttpResponseCallbackNoError {
        @Getter
        private int status = 0;

        @Override
        public void headers(HttpResponseWithoutContent response) {
            status = response.getStatusLine().getStatusCode();
        }

        @Override
        public void chunk(ByteSequence chunk) {
        }

        @Override
        public void done() {
        }
    }

    static class ByteCallback implements HttpResponseCallback {
        @Getter private final ByteArrayOutputStream stream = new ByteArrayOutputStream();
        private final HttpResponseCallback callback = new HttpResponseCallback200ToOutputStream(stream);

        @Override
        public void headers(HttpResponseWithoutContent response) {
            callback.headers(response);
        }

        @Override
        public void chunk(ByteSequence chunk) {
            callback.chunk(chunk);
        }

        @Override
        public void done() {
            callback.done();
        }

        @Override
        public void error(Throwable t) {
            callback.error(t);
        }
    }
}
