package ru.yandex.calendar.logic.contact.directory;

import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.user.Avatar;
import ru.yandex.misc.email.Email;

@Getter
@AllArgsConstructor
public class DirectoryEntry {
    private final String externalId;
    private final DirectoryEntryType type;
    private final Email email;
    private final Option<Email> jabber;

    private final String firstName;
    private final String lastName;
    private final ListF<String> cellPhones;
    private final String workPhone;

    private final String jobOrganization;
    private final String jobTitle;

    private final Option<Avatar> avatar;

    public String getDisplayName() {
        return Cf.list(firstName, lastName).filter(Cf.String::isNotBlank).mkString(" ");
    }

    public static class Builder {
        private Option<DirectoryEntryType> type = Option.empty();
        private Option<Email> email = Option.empty();
        private Option<String> externalId = Option.empty();
        private Option<Email> jabber = Option.empty();

        private String firstName = "";
        private String lastName = "";
        private ListF<String> cellPhones = Cf.list();
        private String workPhone = "";

        private String jobOrganization = "";
        private String jobTitle = "";

        private Option<Avatar> avatar = Option.empty();

        public DirectoryEntry build() {
            return new DirectoryEntry(
                    externalId.getOrThrow("externalId is required"),
                    type.getOrThrow("type is required"),
                    email.getOrThrow("email is required"),
                    jabber,
                    firstName, lastName,
                    cellPhones, workPhone,
                    jobOrganization, jobTitle, avatar);
        }

        public void setType(DirectoryEntryType type) {
            this.type = Option.of(type);
        }

        public void setEmail(Email email) {
            this.email = Option.of(email);
        }

        public void setExternalId(String externalId) {
            this.externalId = Option.of(externalId);
        }

        public void setJabber(Email jabber) {
            this.jabber = Option.of(jabber);
        }

        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public void setCellPhones(ListF<String> cellPhones) {
            this.cellPhones = cellPhones;
        }

        public void setWorkPhone(String workPhone) {
            this.workPhone = workPhone;
        }

        public void setJobOrganization(String jobOrganization) {
            this.jobOrganization = jobOrganization;
        }

        public void setJobTitle(String jobTitle) {
            this.jobTitle = jobTitle;
        }

        public void setAvatar(Option<Avatar> avatar) {
            this.avatar = avatar;
        }
    }
}
