package ru.yandex.calendar.logic.contact.directory.search;

import lombok.AccessLevel;
import lombok.NoArgsConstructor;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function;

@NoArgsConstructor(access = AccessLevel.PRIVATE)
public abstract class DirectorySearchPredicate {
    public boolean isField() {
        return this instanceof FieldPredicate;
    }

    public boolean isAny() {
        return this instanceof AnyPredicate;
    }

    public boolean isAll() {
        return this instanceof AllPredicate;
    }

    public static class FieldPredicate extends DirectorySearchPredicate {
        private final DirectorySearchField field;
        private final DirectorySearchFieldOperator operator;
        private final String value;

        private FieldPredicate(DirectorySearchField field, DirectorySearchFieldOperator operator, String value) {
            this.field = field;
            this.operator = operator;
            this.value = value;
        }

        public DirectorySearchField getField() {
            return field;
        }

        public DirectorySearchFieldOperator getOperator() {
            return operator;
        }

        public String getValue() {
            return value;
        }

        public static Function<FieldPredicate, String> getValueF() {
            return FieldPredicate::getValue;
        }
    }

    public static DirectorySearchPredicate fieldPredicate(DirectorySearchField field, DirectorySearchFieldOperator operator, String value) {
        return new FieldPredicate(field, operator, value);
    }

    public static Function<String, DirectorySearchPredicate> fieldPredicateF(DirectorySearchField field,
                                                                             DirectorySearchFieldOperator operator) {
        return value -> fieldPredicate(field, operator, value);
    }

    public static class AnyPredicate extends DirectorySearchPredicate {
        private final ListF<DirectorySearchPredicate> args;

        private AnyPredicate(ListF<DirectorySearchPredicate> args) {
            this.args = args;
        }

        public ListF<DirectorySearchPredicate> getArgs() {
            return args;
        }
    }

    public static DirectorySearchPredicate anyPredicate(ListF<DirectorySearchPredicate> args) {
        return new AnyPredicate(args);
    }

    public static class AllPredicate extends DirectorySearchPredicate {
        private final ListF<DirectorySearchPredicate> args;

        private AllPredicate(ListF<DirectorySearchPredicate> args) {
            this.args = args;
        }

        public ListF<DirectorySearchPredicate> getArgs() {
            return args;
        }
    }

    public static DirectorySearchPredicate allPredicate(ListF<DirectorySearchPredicate> args) {
        return new AllPredicate(args);
    }

    public static DirectorySearchPredicate falsePredicate() {
        return anyPredicate(Cf.list());
    }

    public static Function<DirectorySearchPredicate, ListF<FieldPredicate>> getLeavesFieldPredicatesF() {
        return predicate -> {
            if (predicate.isField()) {
                return Cf.list((FieldPredicate)predicate);
            }
            ListF<DirectorySearchPredicate> childs = predicate.isAny() ?
                    ((AnyPredicate)predicate).getArgs() :
                    ((AllPredicate)predicate).getArgs();
            return Cf.List.concat(childs.map(getLeavesFieldPredicatesF()));
        };
    }

    public ListF<String> getLeavesFieldPredicatesValues() {
        return getLeavesFieldPredicatesF().apply(this).map(FieldPredicate.getValueF()).stableUnique();
    }
}
