package ru.yandex.calendar.logic.contact.directory.search;

import lombok.Getter;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.calendar.logic.beans.generated.Resource;
import ru.yandex.calendar.micro.yt.entity.YtUser;

@Getter
public class FieldPredicateMatcher {
    private final Function1B<YtUser> userFieldMatcher;
    private final Function1B<Resource> resourceFieldMatcher;

    public FieldPredicateMatcher(Function1B<YtUser> userFieldMatcher, Function1B<Resource> resourceFieldMatcher) {
        this.userFieldMatcher = userFieldMatcher;
        this.resourceFieldMatcher = resourceFieldMatcher;
    }

    public boolean userMatches(YtUser user) {
        return userFieldMatcher.apply(user);
    }

    public boolean resourceMatches(Resource resource) {
        return resourceFieldMatcher.apply(resource);
    }

    static FieldPredicateMatcher any(ListF<FieldPredicateMatcher> matchers) {
        return new FieldPredicateMatcher(
            Function1B.anyOfF(matchers.map(FieldPredicateMatcher::getUserFieldMatcher)),
            Function1B.anyOfF(matchers.map(FieldPredicateMatcher::getResourceFieldMatcher))
        );
    }

    static FieldPredicateMatcher all(ListF<FieldPredicateMatcher> matchers) {
        return new FieldPredicateMatcher(
            Function1B.allOfF(matchers.map(FieldPredicateMatcher::getUserFieldMatcher)),
            Function1B.allOfF(matchers.map(FieldPredicateMatcher::getResourceFieldMatcher))
        );
    }
}
