package ru.yandex.calendar.logic.contact.ml;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.bolts.collection.ListF;

/**
 * @author dbrylev
 */
public class MailList {
    private final ListF<String> whoCanWrite;
    private final boolean readonly;
    private final boolean internal;
    private final boolean open;
    private final ListF<Subscriber> subscribers;

    @JsonCreator
    public MailList(
            @JsonProperty("who_can_write") ListF<String> whoCanWrite,
            @JsonProperty("readonly") boolean readonly,
            @JsonProperty("is_internal") boolean internal,
            @JsonProperty("is_open") boolean open,
            @JsonProperty("subscribers") ListF<Subscriber> subscribers)
    {
        this.whoCanWrite = whoCanWrite;
        this.readonly = readonly;
        this.internal = internal;
        this.open = open;
        this.subscribers = subscribers;
    }

    public ListF<String> getWhoCanWrite() {
        return whoCanWrite;
    }

    public boolean isReadonly() {
        return readonly;
    }

    public boolean isInternal() {
        return internal;
    }

    public boolean isOpen() {
        return open;
    }

    public ListF<Subscriber> getSubscribers() {
        return subscribers;
    }
}
