package ru.yandex.calendar.logic.contact.ml;

import java.net.URI;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.micrometer.core.instrument.MeterRegistry;
import lombok.SneakyThrows;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.tvm.TvmClient;
import ru.yandex.calendar.tvm.TvmHeaders;
import ru.yandex.calendar.util.HttpClientConfiguration;
import ru.yandex.commune.json.jackson.bolts.BoltsModule;
import ru.yandex.inside.utils.JacksonResponseHandlerFactory;
import ru.yandex.misc.email.Email;
import ru.yandex.misc.io.http.UriBuilder;
import ru.yandex.misc.io.http.UrlUtils;

/**
 * https://wiki.yandex-team.ru/maillists/api/directory/
 *
 */
public class Ml {
    private final URI baseUrl;
    private final TvmClient tvmClient;
    private final int mlTvmId;
    private final HttpClient client;
    private final JacksonResponseHandlerFactory responseFactory;

    public Ml(String baseUrl, HttpClientConfiguration httpConf, MeterRegistry registry, TvmClient tvmClient, int mlTvmId) {
        this.baseUrl = UrlUtils.uri(baseUrl);
        this.tvmClient = tvmClient;
        this.mlTvmId = mlTvmId;
        this.client = httpConf.consClient(registry, "ml");
        this.responseFactory = new JacksonResponseHandlerFactory(new ObjectMapper().registerModule(new BoltsModule()));
    }

    @SneakyThrows
    public MailLists listsInfo(ListF<Email> emails, boolean expand) {
        UriBuilder builder = UriBuilder.cons(baseUrl)
                .appendPath("/apiv3/lists/subscribers")
                .addParam("emails", emails.mkString(","))
                .addParam("expand", expand ? "yes" : "no");

        final HttpGet request = new HttpGet(builder.build());
        addServiceTicket(request);
        return client.execute(request, responseFactory.cons(MailLists.class));
    }

    private void addServiceTicket(HttpRequestBase httpRequestBase) {
        httpRequestBase.setHeader(TvmHeaders.SERVICE_TICKET, tvmClient.getServiceTicketFor(mlTvmId));
    }

    public boolean userIsSubscribedToInboxViaMailList(String login, ListF<Email> emails) {
        return listsInfo(emails, true).getLists().values()
                .exists(ml -> ml.getSubscribers().exists(s -> s.getLogin().isSome(login)));
    }
}
