package ru.yandex.calendar.logic.contact.ml;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.email.Email;

/**
 * @author dbrylev
 */
public class Subscriber {
    private final Option<String> login;
    private final Email email;
    private final boolean imap;
    private final boolean inbox;
    private final ListF<Email> via;

    @JsonCreator
    public Subscriber(
            @JsonProperty("login") Option<String> login,
            @JsonProperty("email") Email email,
            @JsonProperty("imap") boolean imap,
            @JsonProperty("inbox") boolean inbox,
            @JsonProperty("via") ListF<Email> via)
    {
        this.login = login;
        this.email = email;
        this.imap = imap;
        this.inbox = inbox;
        this.via = via;
    }

    public Option<String> getLogin() {
        return login;
    }

    public Email getEmail() {
        return email;
    }

    public boolean isImap() {
        return imap;
    }

    public boolean isInbox() {
        return inbox;
    }

    public ListF<Email> getVia() {
        return via;
    }
}
