package ru.yandex.calendar.logic.domain;

import java.util.Properties;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.calendar.PropName;
import ru.yandex.inside.passport.blackbox.PassportAuthDomain;
import ru.yandex.misc.enums.EnumResolver;

/**
 * @author ssytnik
 */
public enum PassportAuthDomains {
    BOTH(PassportAuthDomain.PUBLIC, PassportAuthDomain.YANDEX_TEAM_RU),
    PUBLIC(PassportAuthDomain.PUBLIC),
    YT(PassportAuthDomain.YANDEX_TEAM_RU),
    ;

    private SetF<PassportAuthDomain> domains;

    private PassportAuthDomains(PassportAuthDomain... domains) {
        this.domains = Cf.set(domains);
    }

    public static PassportAuthDomains byProperty(Properties properties) {
        return byProperty(properties.getProperty(PropName.AUTH_DOMAINS.get()));
    }

    public static PassportAuthDomains byProperty(String authDomains) {
        return R.valueOf(authDomains);
    }

    public String getPropertiesPrefix() {
        // XXX: such prefix for 'both' is wrong
        return R.toCamelWords(this != BOTH ? this : PUBLIC).toJavaIdentifier();
    }

    public SetF<PassportAuthDomain> get() {
        return domains;
    }

    public static final EnumResolver<PassportAuthDomains> R = EnumResolver.er(PassportAuthDomains.class);
}
